<?php
/**
 * @file
 * Administration page callbacks for the block_class_styles module.
 *
 * @ingroup block_class_styles
 * @{
 */

/**
 * Form builder. Configure my_module.
 *
 * @ingroup forms
 * @see system_settings_form()
 */

function block_class_styles_admin_settings() {
  $form = array();

  $default = $presets = block_class_styles_info(TRUE);
  $temp = '';
  foreach ($default as $key => $value) {
    $temp .= "$key|$value\n";
  }
  $default = $temp;
  $form['block_class_styles_presets'] = array(
    '#type' => 'textarea',
    '#title' => t('Style definitions'),
    '#description' => t('Enter class/style presets one per line like this: <code>css-class|Style Name</code>.  You may combine multiple classes in one style by separating classes with a space, e.g. <code>some-class another-class|Combo Style</code>'),
    '#default_value' => $default,
    '#rows' => 10,
    '#resizable' => TRUE,
  );

  $suggestions  = array();
  foreach ($presets as $css => $style) {
    $suggestions[$css] = $style . " <code>(" . str_replace('_', '-', _block_class_styles_theme_hook_suggestion($style)) . '.tpl.php' . ")</code>";
  }
  if ($suggestions) {
    $form['suggestions'] = array(
      '#type' => 'fieldset',
      '#title' => t('Template suggestions list'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      0 => array(
        '#theme' => 'item_list', 
        '#items' => $suggestions, 
        '#prefix' => '<h3></h3>', 
      ),
    );     
  }

  $options = array(NULL => t('- system default -'));
  foreach (filter_formats() as $format) {
    $options[$format->format] = $format->name;
  }
  $form['block_class_styles_title_format'] = array(
    '#type' => 'select',
    '#title' => t('Block titles format'),
    '#description' => t('In Drupal core, custom block titles must be plain text.  You may override this by selecting a global format for block titles.  This affects the title you enter when editing a block, not the titles automatically generated by modules.'),
    '#default_value' => variable_get('block_class_styles_title_format', BLOCK_CLASS_STYLES_TITLE_FORMAT),
    '#options' => $options,
  );  

  $form['form_text_overrides'] = array(
    '#type' => 'fieldset',
    '#title' => t('Block Edit Form Settings'),
    '#collapsible' => FALSE,
  );  

  // @todo Find a way to make this work; it is incompatible with the storage mechanism of block_class
  //$form['block_class_styles_allow_multiple'] = array(
  //  '#type' => 'checkboxes',
  //  '#title' => t('Single or Multiple?'),
  //  '#options' => array(TRUE => t('Allow more than one style definition per block?')),
  //  '#default_value' => variable_get('block_class_styles_allow_multiple', BLOCK_CLASS_STYLES_ALLOW_MULTIPLE),
  //);

  $form['form_text_overrides']['block_class_styles_fs_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Fieldset title'),
    '#required' => TRUE, 
    '#default_value' => variable_get('block_class_styles_fs_title', BLOCK_CLASS_STYLES_FS_TITLE),
  );

  $form['form_text_overrides']['block_class_styles_fs_description'] = array(
    '#type' => 'textarea',
    '#rows' => 2,
    '#title' => t('Fieldset instructions'),
    '#default_value' => variable_get('block_class_styles_fs_description', BLOCK_CLASS_STYLES_FS_DESCRIPTION),
  );  

  $form['form_text_overrides']['block_class_styles_form_collapsed'] = array(
    '#type' => 'checkbox',
    '#title' => t('Check to open the %title fieldset by default', array(
      '%title' => variable_get('block_class_styles_fs_title', BLOCK_CLASS_STYLES_FS_TITLE), 
    )),
    '#default_value' => variable_get('block_class_styles_form_collapsed', FALSE),
  );

  $form['form_text_overrides']['block_class_styles_form_weight'] = array(
    '#type' => 'weight',
    '#title' => t('Position in form'),
    '#description' => t('To position the fieldset higher in the form, choose a lower number.'),
    '#default_value' => variable_get('block_class_styles_form_weight', 0),
    '#delta' => 20, //the range is from -1 * delta through delta
  );  

  $form['form_text_overrides']['block_class_styles_title'] = array(
    '#type' => 'textfield',
    '#required' => TRUE, 
    '#title' => t('%title select list title', array(
      '%title' => variable_get('block_class_styles_fs_title', BLOCK_CLASS_STYLES_FS_TITLE), 
    )),
    '#default_value' => variable_get('block_class_styles_title', BLOCK_CLASS_STYLES_TITLE),
  );

  $form['form_text_overrides']['block_class_styles_description'] = array(
    '#type' => 'textarea',
    '#rows' => 2,
    '#title' => t('%title select list description', array(
      '%title' => variable_get('block_class_styles_fs_title', BLOCK_CLASS_STYLES_FS_TITLE), 
    )),
    '#description' => t('Optional text to appear below the selector on the block edit pages.'),
    '#default_value' => variable_get('block_class_styles_description', BLOCK_CLASS_STYLES_DESCRIPTION),
  );

  $default = variable_get('block_class_styles_hidden', array());
  $default = array_keys(array_diff_key($presets, $default));
  $form['form_text_overrides']['block_class_styles_hidden'] = array(
    '#type' => 'checkboxes',
    '#title' => t("%title select list options", array(
      '%title' => variable_get('block_class_styles_fs_title', BLOCK_CLASS_STYLES_FS_TITLE), 
    )),
    '#description' => t('Uncheck any style you wish to be hidden on block edit forms'), 
    '#options' => $presets,
    '#default_value' => $default,
  );

  //$form['form_text_overrides']['block_class_styles_hide_classes'] = array(
  //  '#type' => 'checkbox',
  //  '#title' => t('Check this box to hide the <strong>CSS class(es)</strong> textfield created by the Block Class module.'),
  //  '#default_value' => variable_get('block_class_styles_hide_classes', BLOCK_CLASS_STYLES_HIDE_CLASSES),
  //);

  $form['#validate'][] = 'block_class_styles_admin_settings_validate';
  return system_settings_form($form);
}

/**
 * Form validation handler for block_class_styles_admin_settings_validate().
 */
function block_class_styles_admin_settings_validate($form, &$form_state) {
  $presets  = &$form_state['values']['block_class_styles_presets'];
  $hidden   = &$form_state['values']['block_class_styles_hidden'];

  // Invert our selection because active looks better in the UI, but hidden
  // stores with less memory.
  $hidden = array_diff_key(block_class_styles_info(TRUE), array_filter($hidden));

  $temp = explode("\n", trim($presets));
  if (empty($temp) || empty($temp[0])) {
    $presets = NULL;
    return;
  }

  $temp3 = array();
  foreach ($temp as $value) {
    if (!strstr($value, '|')) {
      form_set_error('block_class_styles_presets', t('Separate class and Style Name with a pipe |'));
    }
    else {
      $temp2 = explode('|', trim($value));
      $temp3[$temp2[0]] = $temp2[1];
    }
  }
  $presets = $temp3;
  $new_presets = array_flip($presets);
  $old_presets = array_flip(block_class_styles_info());
  $diff = array_diff($old_presets, $new_presets);
  foreach (array_keys($diff) as $style) {
    if (!array_key_exists($style, $new_presets)) {
      form_set_error('block_class_styles_presets', t('You <b>cannot change both style name and css definition at the same time</b>.  This must be done in two saves. To delete a style, use the checkboxes below the Style Definitions.'));
    }
    else {
      // The admin has changed a css class and we need to update the database
      // directly.
      db_update(_block_class_tablename())
      ->fields(array('css_class' => $new_presets[$style]))
      ->condition('css_class', $old_presets[$style])
      ->execute();
    }
  }
}

/** @} */ //end of group block_class_styles1
